/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Audio.AudioPlayer;
import Entity.MenuOption;
import Entity.Mouse;
import GameState.GameState;
import GameState.GameStateManager;
import Handlers.Keys;
import Handlers.Options;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

public class OptionsState
extends GameState {
    private int currentChoice = 0;
    private String[] options = new String[]{"Mute Music : ", "Mute SFX : ", "Show FPS : ", "Show Game Hit Boxes : ", "Show Menu Hit Boxes : ", "Use Mouse Menu Controls : ", "Back"};
    private Font font;
    private MenuOption mo;
    private MenuOption mo2;
    private Mouse mouse;

    public OptionsState(GameStateManager gsm) {
        this.gsm = gsm;
        this.font = new Font("Arial", 0, 22);
        this.mo = new MenuOption(this.options, 1, this.font, 400, 50, 0, 40);
        this.mo2 = new MenuOption("Back", gsm.regFont, 400, 350);
        this.mouse = new Mouse();
    }

    @Override
    public void init() {
    }

    @Override
    public void update() {
        this.handleInput();
        this.mo.update(this.mouse);
        this.mo2.update(this.mouse);
        this.mouse.update();
    }

    @Override
    public void draw(Graphics2D g) {
        g.setFont(this.font);
        g.setColor(Color.WHITE);
        if (Options.getOption(0)) {
            g.setColor(Color.yellow);
            this.gsm.drawCenteredString("ON", 1000, 100, g);
        } else {
            g.setColor(Color.white);
            this.gsm.drawCenteredString("OFF", 1000, 100, g);
        }
        if (Options.getOption(1)) {
            g.setColor(Color.yellow);
            this.gsm.drawCenteredString("ON", 1000, 180, g);
        } else {
            g.setColor(Color.white);
            this.gsm.drawCenteredString("OFF", 1000, 180, g);
        }
        if (Options.getOption(2)) {
            g.setColor(Color.yellow);
            this.gsm.drawCenteredString("ON", 1000, 260, g);
        } else {
            g.setColor(Color.white);
            this.gsm.drawCenteredString("OFF", 1000, 260, g);
        }
        if (Options.getOption(3)) {
            g.setColor(Color.yellow);
            this.gsm.drawCenteredString("ON", 1100, 340, g);
        } else {
            g.setColor(Color.white);
            this.gsm.drawCenteredString("OFF", 1100, 340, g);
        }
        if (Options.getOption(4)) {
            g.setColor(Color.yellow);
            this.gsm.drawCenteredString("ON", 1100, 420, g);
        } else {
            g.setColor(Color.white);
            this.gsm.drawCenteredString("OFF", 1100, 420, g);
        }
        if (Options.getOption(5)) {
            g.setColor(Color.yellow);
            this.gsm.drawCenteredString("ON", 1150, 500, g);
        } else {
            g.setColor(Color.white);
            this.gsm.drawCenteredString("OFF", 1150, 500, g);
        }
        if (Options.getOption(5)) {
            this.mo.draw(g);
            g.setFont(this.gsm.regFont);
            this.mo2.draw(g);
            this.mouse.draw(g);
        } else {
            int i = 0;
            while (i < this.options.length) {
                if (i == this.currentChoice) {
                    g.setColor(Color.YELLOW);
                } else {
                    g.setColor(Color.WHITE);
                }
                if (i != this.options.length - 1) {
                    this.gsm.drawCenteredString(this.options[i], 800, 100 + i * 80, g);
                } else {
                    g.setFont(this.gsm.regFont);
                    this.gsm.drawCenteredString(this.options[i], 800, 700, g);
                }
                ++i;
            }
        }
    }

    private void select(int currentChoice) {
        if (currentChoice == 0) {
            if (Options.getOption(0)) {
                Options.setOption(0, false);
                AudioPlayer.play("introMusic", 0.0);
            } else {
                Options.setOption(0, true);
                AudioPlayer.stop("introMusic");
            }
        }
        if (currentChoice == 1) {
            if (Options.getOption(1)) {
                Options.setOption(1, false);
            } else {
                Options.setOption(1, true);
            }
        }
        if (currentChoice == 2) {
            if (Options.getOption(2)) {
                Options.setOption(2, false);
            } else {
                Options.setOption(2, true);
            }
        }
        if (currentChoice == 3) {
            if (Options.getOption(3)) {
                Options.setOption(3, false);
            } else {
                Options.setOption(3, true);
            }
        }
        if (currentChoice == 4) {
            if (Options.getOption(4)) {
                Options.setOption(4, false);
            } else {
                Options.setOption(4, true);
            }
        }
        if (currentChoice == 5) {
            if (Options.getOption(5)) {
                Options.setOption(5, false);
                Options.setOption(4, false);
            } else {
                Options.setOption(5, true);
            }
        }
        if (currentChoice == 6) {
            this.gsm.setState(0);
        }
        Options.setOptions();
    }

    @Override
    public void handleInput() {
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            this.gsm.setState(0);
        }
        if (Options.getOption(5)) {
            if (Keys.isMousePressed(Keys.LEFTCLICK)) {
                this.select(this.mo.getChoice());
            }
            if (Keys.isMousePressed(Keys.LEFTCLICK) && this.mo2.getChoice() != -1) {
                this.select(this.mo2.getChoice() + 6);
            }
        } else {
            if (Keys.isKeyPressed(Keys.ENTER)) {
                this.select(this.currentChoice);
            }
            if (Keys.isKeyPressed(Keys.UP)) {
                this.currentChoice = this.currentChoice > 0 ? --this.currentChoice : this.options.length - 1;
            }
            if (Keys.isKeyPressed(Keys.DOWN)) {
                this.currentChoice = this.currentChoice < this.options.length - 1 ? ++this.currentChoice : 0;
            }
        }
    }
}

